<?php defined('SYSPATH') or die('No direct script access.');
/**
* Set the routes. Each route must have a minimum of a name, a URI and a set of
* defaults for the URI.
*/

Route::set('rest', '<directory>/<controller>/<action>(/<page>)', ['directory' => 'rest', 'page' => '[0-9]+'])
    ->defaults([
        'directory' => 'rest',
        'controller' => 'rest_luhn',
        'action' => 'index',
    ]);

Route::set('more', '<controller>/<action>(/<name>)/<id>', [
		'controller' => 'logpost',
		'action' => 'more',
		'name' => '[0-9A-F]+',
		'id'  => '[0-9]+'
	])->defaults([
		'controller' => 'logpost',
		'action'     => 'more',
	]
);

Route::set('mini', '<controller>/<action>(/page(/<page>))', [
        'controller' => 'logpost',
        'action' => 'mini',
        'page' => '[0-9]+',
    ])->defaults([
        'controller' => 'logpost',
        'action'     => 'mini',
    ]
);

Route::set('luhn', '<controller>', ['controller' => 'luhn'])
    ->defaults([
            'controller' => 'luhn',
            'action'     => 'index',
        ]
    );

Route::set('email', '<controller>(/<page>)', ['controller' => 'email', 'page' => '[0-9]+'])
    ->defaults([
            'controller' => 'email',
            'action'     => 'index',
        ]
    );

Route::set('more_ex', '<controller>/<action>/<id>(/<page>)', ['controller' => 'logpost', 'action' => 'more_ex', 'page' => '[0-9]+'])
    ->defaults([
            'controller' => 'logpost',
            'action'     => 'more_ex',
        ]
    );

Route::set('post', '(page(/<page>))', ['controller' => 'Logpost', 'page' => '[0-9]+'])
	->defaults([
			'controller' => 'logpost',
			'action'     => 'index',
		]
	);

Route::set('logs', 'logs(/page(/<page>))', array('controller' => 'Logs', 'page' => '[0-9]+'))
	->defaults([
			'controller' => 'logs',
			'action'     => 'index',
		]
	);

Route::set('worker_check', 'worker(/<controller>(/<action>(/<id>)))')
	->defaults([
			'directory' => 'Worker',
			'controller' => 'Check',
			'action'     => 'index',
		]
	);

Route::set('insert_blacklist', 'insert(/<controller>(/<action>(/<type>(/<id>))))')
	->defaults([
			'directory' => 'Insert',
			'controller' => 'Blacklist',
			'action'     => 'index',
		]
	);

Route::set('default', '(<controller>(/<action>(/<id>(/<id2>))))')
	->defaults([
		'controller' => 'logpost',
		'action'     => 'index',
	]
);


Route::set('api', 'api/<controller>/<action>(/<page>)', ['action' => 'clients|logpost', 'page' => '[0-9]+'])
        ->defaults([
            'directory'=>'Api',
            'controller' => 'Favorites'
        ]);
